<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldShowOnHomePageToWalls extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('walls', 'show_on_home_page', [
            'name' => 'show_on_home_page',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Remonte sur la page d\'accueil',
            ],
            'description' => [
                'fr' => 'Si le "Remonte sur la page d\'accueil" est activé, la discussion sera affichée sur la page d\'accueil',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);
    }
}
