<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Contents\Walls;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

class UpdateWallsNotificationTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        Walls::where('status', 1)
            ->each(function ($wall) {
                $users = Users::query()
                    ->where('langcode', $wall->langcode)
                    ->where('status', 1)
                    ->pluck('uuid');

                NotificationType::where('condition', "walls:$wall->uuid")
                    ->each(function (NotificationType $notificationType) use ($users) {
                        $notificationType->update(['default' => true]);
                        $notificationType->subscribers()->syncWithoutDetaching($users);
                    });
            });
    }
}
