<?php

declare(strict_types=1);

namespace Inside\Vacation\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Contents\Vacations;
use Inside\Vacation\Http\Requests\VacationValidationRequest;
use Inside\Vacation\Models\VacationValidation;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

final class VacationsValidationsController extends Controller
{
    public function updateStatus(string $uuid, VacationValidationRequest $request): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        $vacation = Vacations::find($uuid);

        if (! $vacation instanceof Vacations) {
            throw new NotFoundHttpException("Vacation $uuid not found.");
        }

        if (! $user->isSuperAdmin() && ! $vacation->validator->contains('uuid', $user->uuid)) {
            throw new AccessDeniedHttpException("User $user->uuid is not a validator");
        }

        $status = $request->validated('status');

        if ($user->isSuperAdmin()) {
            $validation = $vacation
                ->validator
                ->map(fn (Users $user) => VacationValidation::updateOrCreate(['model_uuid' => $vacation->uuid, 'user_uuid' => $user->uuid], ['status' => $status]))
                ->first();
        } else {
            $validation = VacationValidation::updateOrCreate(['model_uuid' => $vacation->uuid, 'user_uuid' => $user->uuid], ['status' => $status]);
        }

        return response()
            ->json(
                data: [
                    'status' => $validation->status,
                    'updated_at' => $validation->updated_at,
                ]
            );
    }
}
