<?php

declare(strict_types=1);

namespace Inside\Vacation\Contracts;

use Inside\Content\Models\Contents\Vacations;

interface VacationValidator
{
    public const STATUS_VALIDATED = 'validated';
    public const STATUS_REFUSED = 'refused';
    public const STATUS_IN_PROGRESS = 'in_progress';

    public const STATUSES = [
        self::STATUS_VALIDATED,
        self::STATUS_REFUSED,
        self::STATUS_IN_PROGRESS,
    ];

    public function computeVacationStatus(Vacations $vacation): void;
}
