<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

class CreateNotificationTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (NotificationType::where('model', 'Inside\Content\Models\Contents\Vacations')->exists()) {
            return;
        }

        $notificationTypes = [];

        // création demande de congés
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'data' => [
                    'title' => 'notifications.create.content.vacations.title',
                    'description' => 'notifications.create.content.vacations.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.text',
                    'fields' => [],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'data' => [
                    'title' => 'notifications.create.content.vacations.title',
                    'description' => 'notifications.create.content.vacations.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.vacations.mail.subject',
                        'text' => 'notifications.create.content.vacations.mail.text',
                        'buttonText' => 'notifications.create.content.vacations.mail.buttonText'
                    ],
                    'fields' => [],
                ],
            ]
        );

        // Réponse demande de congés
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'data' => [
                    'title' => 'notifications.create.content.vacations.status.updated.title',
                    'description' => 'notifications.create.content.vacations.status.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.status.updated.text',
                    'fields' => [
                        'status'
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'data' => [
                    'title' => 'notifications.create.content.vacations.status.updated.title',
                    'description' => 'notifications.create.content.vacations.status.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.status.updated.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.vacations.status.updated.mail.subject',
                        'text' => 'notifications.create.content.vacations.status.updated.mail.text',
                        'buttonText' => 'notifications.create.content.vacations.mail.buttonText'
                    ],
                    'fields' => [
                        'status'
                    ],
                ],
            ]
        );
    }
}
