<?php

declare(strict_types=1);

namespace Inside\Vacation\Providers;

use Inside\Content\Events\ContentSynchedEvent;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\Vacation\Contracts\VacationValidator;
use Inside\Vacation\Http\Middlewares\InjectValidationStatusesMiddleware;
use Inside\Vacation\Listeners\VacationsUpdatedListener;
use Inside\Vacation\Models\VacationValidation;
use Inside\Vacation\Observers\VacationValidationObserver;
use Inside\Vacation\Services\VacationValidatorService;

final class VacationServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentSynchedEvent::class => [
            VacationsUpdatedListener::class,
        ],
    ];

    public array $bindings = [
        VacationValidator::class => VacationValidatorService::class,
    ];

    public function boot(): void
    {
        parent::boot();

        VacationValidation::observe(VacationValidationObserver::class);
    }

    public function register(): void
    {
        $this->app->middleware([
            InjectValidationStatusesMiddleware::class,
        ]);
    }
}
