<?php

declare(strict_types=1);

namespace Inside\Vacation\Observers;

use Inside\Vacation\Contracts\VacationValidator;
use Inside\Vacation\Models\VacationValidation;

final class VacationValidationObserver
{
    public function __construct(
        private VacationValidator $vacationValidator
    ) {
    }

    public function saved(VacationValidation $vacationValidation): void
    {
        $this->vacationValidator->computeVacationStatus($vacationValidation->model);
    }

    public function deleted(VacationValidation $vacationValidation): void
    {
        $this->vacationValidator->computeVacationStatus($vacationValidation->model);
    }
}
