<?php

declare(strict_types=1);

namespace Inside\Vacation\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Contents\Users;
use Inside\Content\Models\Contents\Vacations;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;
use Inside\Permission\Scopes\AllowedScope;

/**
 * @property int $id
 * @property int $created_at
 * @property int $updated_at
 * @property string $status
 * @property Users $user
 * @property Vacations $model
 *
 * @method static static updateOrCreate(array $attributes, array $values = [])
 * @method static Builder query()
 */
class VacationValidation extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'inside_vacations_validations';

    /**
     * @var string[]
     */
    protected $fillable = [
        'user_uuid',
        'model_uuid',
        'status',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(Users::class);
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(Vacations::class)->withoutGlobalScope(AllowedScope::class);
    }
}
