<?php

declare(strict_types=1);

namespace Inside\Vacation\Http\Requests;

use Illuminate\Validation\Rule;
use Inside\Http\Requests\FormRequest;
use Inside\Vacation\Contracts\VacationValidator;

final class VacationValidationRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'status' => [
                'required',
                'string',
                Rule::in(VacationValidator::STATUSES),
            ],
        ];
    }
}
