<?php

declare(strict_types=1);

namespace Inside\Vacation\Helpers;

use Inside\Content\Models\Contents\Vacations;

final class UrlHelper
{
    public static function getModalUrl(string $basePageUrl, Vacations $model): string
    {
        $content_type = $model->content_type;
        $uuid = $model->uuid;

        return "${basePageUrl}#&modal/${content_type}/${uuid}";
    }
}
