<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

final class MakeVacationsStatusPermissible extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdate('vacations_status', [
            'name' => 'vacations_status',
            'permissible' => true,
            'categorizable' => false,
            'listing_type' => 'hidden',
        ]);

        Artisan::call('models:rebuild');
    }
}
