<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\VacationsStatus;
use Inside\Host\Bridge\BridgeContent;
use Inside\Vacation\Contracts\VacationValidator;

final class FixVacationsDefaultStatus extends Migration
{
    public function up(): void
    {
        $vs = VacationsStatus::where("value", VacationValidator::STATUS_IN_PROGRESS)->first();
        $bridge = new BridgeContent();
        $bridge->setReferenceDefaultValue('vacations', 'vacations_status', [
            $vs->uuid
        ]);
    }
}
