<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\VacationsTimeframes;
use Inside\Host\Bridge\BridgeContent;

class CreateVacationsTimeframesContents extends Migration
{
    private const CONTENTS = [
        [
            'fr' => 'Matin',
            'en' => 'Morning',
            'es' => 'Mañana',
            'de' => 'Morgen',
            'pt' => 'Manhã',
            'nl' => 'Ochtend',
        ],
        [
            'fr' => 'Après-Midi',
            'en' => 'Afternoon',
            'es' =>  'Tarde',
            'de' => 'Nachmittag',
            'pt' => 'Tarde',
            'nl' => 'Middag'
        ],
        [
            'fr' => 'Journée entière',
            'en' => 'Whole day',
            'es' => 'Día completo',
            'de' => 'Ganzer Tag',
            'pt' => 'Dia inteiro',
            'nl' => 'Hele dag'
        ]
    ];

    public function up(): void
    {
        $locale = config('app.locale');
        $bridge = new BridgeContent();

        foreach (self::CONTENTS as $titles) {
            $uuid = $bridge->contentInsert('vacations_timeframes', [
                'type' => 'node',
                'bundle' => 'vacations_timeframes',
                'langcode' => $locale,
                'title' => $titles[$locale],
            ]);

            $original = VacationsTimeframes::findOrFail($uuid);
            collect(list_languages())
                ->reject($locale)
                ->each(fn (string $language) => $bridge->contentInsert('vacations_timeframes', [
                    'type' => 'node',
                    'bundle' => 'vacations_timeframes',
                    'langcode' => $language,
                    'title' => $titles[$language],
                    'uuid_host' => $original->uuid_host
                ]));
        }
    }
}
