<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class CreateVacationsTimeframes extends Migration
{
    use CreateContentTypes;

    private const FIELDS = [
        "start_timeframes" => 2,
        "end_timeframes" => 3,
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('vacations_timeframes');

        Artisan::call('models:rebuild');

        collect(self::FIELDS)->each(fn (int $weight, string $name) =>
        $this->getBridge()?->contentTypeCreateOrUpdateField('vacations', $name, [
            'name' => $name,
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Moment de la journée',
                'en' => 'Time of day',
                'es' => 'Hora del día',
                'de' => 'Tageszeit',
                'pt' => 'Hora do dia',
                'nl' => 'Moment van de dag.'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'vacations_timeframes',
                'cardinality' => 1,
            ],
        ], $weight));

        Artisan::call('models:rebuild');

        $this->finishUp();
    }
}
