<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class CreateVacationsValidationsTable extends Migration
{
    public function up(): void
    {
        Schema::dropIfExists('inside_vacations_validations');

        Schema::create('inside_vacations_validations', function (Blueprint $table) {
            $table->increments('id');
            $table->uuid('model_uuid')->collation('utf8mb4_unicode_ci');
            $table->uuid('user_uuid')->collation('utf8mb4_unicode_ci');
            $table->string('status');
            $table->timestamps();

            $table->foreign('model_uuid')
                ->references('uuid')
                ->on(type_to_table('vacations'))
                ->onDelete('cascade');

            $table->foreign('user_uuid')
                ->references('uuid')
                ->on(type_to_table('users'))
                ->onDelete('cascade');

            $table->index(['model_uuid', 'user_uuid']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_vacations_validations');
    }
}
