<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Collection;
use Inside\Content\Models\Contents\Vacations;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationSubscriber;

class AddSubscribersToVacationNotif extends Migration
{
    public function up(): void
    {
        $users = Users::all();
        /** @var Collection<NotificationType> $notificationTypes */
        $notificationTypes = NotificationType::where('model', 'Inside\Content\Models\Contents\Vacations')->where('default', 0)->get();
        foreach ($notificationTypes as $notificationType) {
            $notificationType->default = 1;
            $notificationType->save();
            $users->each(function ($user) use ($notificationType) {
                NotificationSubscriber::firstOrCreate([
                    'user_uuid'            => $user->uuid,
                    'notification_type_id' => $notificationType->id,
                ]);
            });
        };
    }
}
