<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Vacations;
use Inside\Host\Bridge\BridgeContent;

class UpdateDate extends Migration
{
    public function up(): void
    {
        if (Schema::hasField('vacations', 'date_start') && Schema::hasField('vacations', 'date_end')) {
            $bridge = new BridgeContent();
            $vacations = Vacations::where('status', 1)->get();

            foreach ($vacations as $vacation) {
                $bridge->contentUpdate('vacations', [
                    'uuid' => $vacation->uuid,
                    'date' => $vacation->date_start,
                    'end_date' => $vacation->date_end,
                ]);
            }
        }
    }
}
