<?php

namespace Inside\OneLogin\Services;

use OneLogin\api\OneLoginClient;

class OneLoginApiService
{
    private ?OneLoginClient $client = null;

    private function __construct(
        private string $clientId,
        private string $clientSecret,
        private string $region,
    ) {
    }

    public static function load(array $config): self
    {
        return new self(
            clientId: $config['client_id'],
            clientSecret: $config['client_secret'],
            region: $config['region'],
        );
    }

    public function getClient(): OneLoginClient
    {
        return $this->client ??= new OneLoginClient($this->clientId, $this->clientSecret, $this->region);
    }
}
