
# Inside User OneLogin

# Requirements

| Requirement| Description                                   |
|------------|-----------------------------------------------|
| ONELOGIN_CLIENT_ID | Client ID of the application                  |
| ONELOGIN_CLIENT_SECRET | Client secret of the application              |
| ONELOGIN_REGION | Region of the application (us, eu) Default:eu |

https://developers.onelogin.com/api-docs/1/getting-started/working-with-api-credentials

Creating an API Credential Pair
1. Access OneLogin as an account owner or administrator.
2. Go to Developers > API Credentials.
3. On the API Access page, click New Credential.
   - Name: Maecia
   - Scope: Read Users
4. Click Save and **copy your client secret and client ID**
5. Click Done

# Installation

 1. Edit your .env file to put the following lines :

```
    ONELOGIN_CLIENT_ID=your_client_id
    ONELOGIN_CLIENT_SECRET=your_client_secret
```

# OneLogin Documentation
> [How to get users data](https://developers.onelogin.com/api-docs/2/users/list-users)

> [Package PHP OneLogin SDK](https://github.com/onelogin/onelogin-php-sdk)

# Importation

```bash
 php artisan inside:user:import onelogin
 php artisan inside:user:dump onelogin
```
