<?php

namespace Inside\LDAP\Providers;

use Adldap\Laravel\AdldapAuthServiceProvider;
use Adldap\Laravel\AdldapServiceProvider;
use Illuminate\Container\Container;
use Inside\LDAP\Console\DumpCommand;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Inside package user via LDAP service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class LDAPServiceProvider extends EventServiceProvider
{
    protected array $commands = [
        DumpCommand::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/ldap.php', 'ldap');
            $this->mergeConfigFrom(__DIR__.'/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/import.php', 'import');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
        $this->app->register(AdldapServiceProvider::class);
        $this->app->register(AdldapAuthServiceProvider::class);
    }
}
