<?php

namespace Inside\LDAP\LDAP;

use Inside\Authentication\Exceptions\CredentialsValidatorException;
use Inside\Authentication\Validators\AuthenticationValidator;
use Inside\Authentication\Models\User;
use Adldap\Laravel\Facades\Resolver as LDAPResolver;
use Inside\Authentication\Exceptions\UserNotFoundException;
use Inside\Authentication\Exceptions\PasswordNotValidException;

/**
 * Class Authenticator
 *
 * @package Inside\LDAP\LDAP
 */
class Authenticator
{
    /**
     * Attempt to connect with this authenticator against $credentials
     *
     * throws an exception if failed otherwise, the connected user
     *
     * @throws PasswordNotValidException
     * @throws UserNotFoundException
     */
    public function attempt(array $credentials): User
    {
        // We load our Inside user same as normal connection
        $this->validate($credentials);

        $column = isset($credentials['name']) ? 'name' : 'email';

        /** @var ?User $user */
        $user = User::where('email', '=', $credentials[$column])
            ->orWhere('name', '=', $credentials[$column])
            ->first();

        if (!$user) {
            throw new UserNotFoundException('No account found with ' . $column . ': ' . $credentials[$column], 400); // TODO corriger l'exception pour qu'elle prenne un status en paramètre.
        }

        // Get our LDAP user
        $ldapuser = LDAPResolver::byModel($user);

        // Try to authenticate with LDAP
        if (!$ldapuser || ! LDAPResolver::authenticate($ldapuser, $credentials)) {
            throw new PasswordNotValidException('Incorrect password', 400); // TODO corriger l'exception pour qu'elle prenne un status en paramètre.
        }

        // LDAP Is ok with our authentication
        return $user;
    }


    /**
     * Validate authentication
     * @throws CredentialsValidatorException
     */
    protected function validate(array $credentials): void
    {
        $validator = new AuthenticationValidator();
        $validator->validate($credentials);
    }
}
