<?php

use Adldap\Laravel\Events\Authenticated;
use Adldap\Laravel\Events\AuthenticatedModelTrashed;
use Adldap\Laravel\Events\AuthenticatedWithWindows;
use Adldap\Laravel\Events\Authenticating;
use Adldap\Laravel\Events\AuthenticationFailed;
use Adldap\Laravel\Events\AuthenticationRejected;
use Adldap\Laravel\Events\AuthenticationSuccessful;
use Adldap\Laravel\Events\DiscoveredWithCredentials;
use Adldap\Laravel\Events\Importing;
use Adldap\Laravel\Events\Synchronized;
use Adldap\Laravel\Events\Synchronizing;
use Adldap\Laravel\Listeners\LogAuthenticated;
use Adldap\Laravel\Listeners\LogAuthentication;
use Adldap\Laravel\Listeners\LogAuthenticationFailure;
use Adldap\Laravel\Listeners\LogAuthenticationRejection;
use Adldap\Laravel\Listeners\LogAuthenticationSuccess;
use Adldap\Laravel\Listeners\LogDiscovery;
use Adldap\Laravel\Listeners\LogImport;
use Adldap\Laravel\Listeners\LogSynchronized;
use Adldap\Laravel\Listeners\LogSynchronizing;
use Adldap\Laravel\Listeners\LogTrashedModel;
use Adldap\Laravel\Listeners\LogWindowsAuth;
use Inside\Authentication\Models\User;

return [
    'connection' => env('ADLDAP_CONNECTION', 'default'),
    'provider' => Adldap\Laravel\Auth\DatabaseUserProvider::class,
    'model' => User::class,
    'rules' => [
        Adldap\Laravel\Validation\Rules\DenyTrashed::class,
    ],
    'scopes' => [
    ],
    'identifiers' => [
        'ldap' => [
            'locate_users_by' =>  env('ADLDAP_LDAP_DISCOVER', 'mail'),
            'bind_users_by' =>  env('ADLDAP_LDAP_AUTHENTICATE', 'mail'),
        ],
        'database' => [
            'guid_column' => env('ADLDAP_GUID_COLUMN', 'objectguid'),
            'username_column' => env('ADLDAP_ELOQUENT_VALUE', 'email'),
        ],
        'windows' => [
            'locate_users_by' => env('ADLDAP_WINDOWS_DISCOVER', 'samaccountname'),
            'server_key' =>  env('ADLDAP_WINDOWS_KEY', 'AUTH_USER'),
        ],
    ],
    'passwords' => [
        'sync' => env('ADLDAP_PASSWORD_SYNC', false),
        'column' => 'password',
    ],
    'login_fallback' => env('ADLDAP_LOGIN_FALLBACK', false),
    'sync_attributes' => [
        'email'           => 'mail',
        'name'            => 'uid',
        'field_firstname' => 'givenname',
        'field_lastname'  => 'sn',
    ],
    'discovering_attribute' => 'cn',
    'logging' => [
        'enabled' => env('ADLDAP_LOGGING', true),
        'events' => [
            Importing::class => LogImport::class,
            Synchronized::class => LogSynchronized::class,
            Synchronizing::class => LogSynchronizing::class,
            Authenticated::class => LogAuthenticated::class,
            Authenticating::class => LogAuthentication::class,
            AuthenticationFailed::class => LogAuthenticationFailure::class,
            AuthenticationRejected::class => LogAuthenticationRejection::class,
            AuthenticationSuccessful::class => LogAuthenticationSuccess::class,
            DiscoveredWithCredentials::class => LogDiscovery::class,
            AuthenticatedWithWindows::class => LogWindowsAuth::class,
            AuthenticatedModelTrashed::class => LogTrashedModel::class,
        ],
    ],
];
