<?php

namespace Inside\LDAP\Console;

use Adldap\Laravel\Facades\Adldap;
use Inside\Console\Command;

class DumpCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'ldap:dump';

    /*
     * @var string
     */
    protected $signature = 'ldap:dump {cn}';

    /**
     * @var string
     */
    protected $description = 'Dump a user from ldap';

    public function handle(): int
    {
        /** @var string $cn */
        $cn = $this->argument('cn');

        $results = Adldap::search()->where('cn', '=', $cn)->get();
        foreach ($results as $result) {
            $values = [];
            foreach ($result->getAttributes() as $attribute => $value) {
                if (is_string($attribute)) {
                    $values[] = [$attribute, implode("\n", (array)$value)];
                }
            }
            $this->table(['attribute', 'values'], $values);
        }
        return Command::SUCCESS;
    }
}
