<?php

namespace Inside\Google\Providers;

use Inside\Support\EventServiceProvider;
use Laravel\Socialite\SocialiteServiceProvider;
use Laravel\Socialite\Facades\Socialite;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Inside package authentication Google service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class GoogleServiceProvider extends EventServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/google.php', 'google');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/import.php', 'import');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->register(SocialiteServiceProvider::class);
        $this->app->alias('Socialite', Socialite::class);
    }
}
