# Inside User Google
## .env settings

| Parameter                       | Value                                               |
|---------------------------------|-----------------------------------------------------|
| GOOGLE_CLIENT_ID                | The Google client ID                                |
| GOOGLE_CLIENT_SECRET            | The Google App Secret                               |
| GOOGLE_DOMAIN                   | The Google domain                                   |
| GOOGLE_SERVICE_ACCOUNT_NAME     | The Google admin email                              |
| GOOGLE_SERVICE_ACCOUNT_KEY_PATH | The path for the service account key on the server  |
| GOOGLE_SERVICE_ACCOUNT_KEY_B64  | The base64 encoded service account key (optional)   |

To base64 encode the service account key, you can use the following command:

```bash
GOOGLE_CREDENTIALS_B64=$(cat service.json | base64 -w 0)
echo $GOOGLE_CREDENTIALS_B64
```

To decode the base64 encoded service account key, you can use:

```bash
echo $GOOGLE_CREDENTIALS_B64 | base64 -d
```

Note: the service account name is required for the directory import: the service account uses this address to act as an admin

## Google Developer Console (client side)

The Admin SDK and Google People API must be activated here:
https://console.developers.google.com/

Once the APIs are activated, several things must be created and set in the console (Idents tab):

- An API key
- An oAuth client ID with authorized Javascript origins:
    - https://[code].staging.maecia.com
    - The production URL once it is known
- The authorized redirect URLs:
    - https://[code].staging.maecia.com/google/login/callback
    - [production]/google/login/callback
- A service account key (JSON). The file is downloadable only once.

## Google Admin Console (client side)

https://admin.google.com/

Some settings must be set in the Admin console, in Security > Advanced parameters > Manage API client access:

- Add a new authorization
- The client name is the service account client ID previously generated
- In "Applications", put `https://www.googleapis.com/auth/admin.directory.user,https://www.googleapis.com/auth/admin.directory.group`

## google.php config file

A `google.php` config file must be created in the instance back repository:

```php
<?php

return [
    'client_id'     => env('GOOGLE_CLIENT_ID'),
    'client_secret' => env('GOOGLE_CLIENT_SECRET'),
    'service_account_name' => env('GOOGLE_SERVICE_ACCOUNT_NAME'),
    'service_account_key_path' => env('GOOGLE_SERVICE_ACCOUNT_KEY_PATH'),
    'hd' => env('GOOGLE_DOMAIN'),
    'scopes' => [
        'https://www.googleapis.com/auth/admin.directory.user',
        'https://www.googleapis.com/auth/admin.directory.group'
    ],
    'sync_attributes' => [
        'mail' => 'getPrimaryEmail',
        'name' => 'getPrimaryEmail',
        'firstname' => function(\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['givenName'];
        },
        'lastname' => function(\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['familyName'];
        }
    ],
];
```
