<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace' => 'Inside\CSV\Http\Controllers',
        'prefix' => 'api/v1'
    ],
    function ($router) {
        $router->get('export/template', ['uses' => 'TemplateController@download']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\CSV\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => 'super_admin'
    ],
    function ($router) {
        $router->get('import/fields', ['uses' => 'CsvController@getFields']);
        $router->get('csv/separator', ['uses' => 'CsvController@getSeparator']);

        $router->post('csv/import', ['uses' => 'UserImportController@import']);
        $router->get('csv/statistics', ['uses' => 'UserImportController@stats']);

        $router->post('csv/send', ['uses' => 'FeedValidationController@send']);
        $router->get('csv/check', ['uses' => 'FeedValidationController@check']);
    }
);
