<?php

namespace Inside\CSV\Traits;

use Illuminate\Support\Facades\File;

trait FeedConfig
{
    private function getFilePath(string $format): ?string
    {
        $code = config('app.code');
        return config($format.'.files.' . $code.'.path');
    }

    private function setFilePath(string $format, string $filePath): void
    {
        $code = config('app.code');
        $toFilePath = config($format.'.files.' . $code.'.path');

        if (
            !File::exists(storage_path('app/imports'))
        ) {
            File::makeDirectory(storage_path('app/imports'), 0755, true);
        }

        $toPath = realpath(dirname($toFilePath)) . '/' . basename($toFilePath);
        copy($filePath, $toPath);
    }

    private function originalHeaders(string $format): array
    {
        $code = config('app.code');
        return config($format.'.files.' . $code.'.original_fields') ?? [];
    }

    private function expectedColumns(string $format): array
    {
        return array_keys(
            self::originalHeaders($format)
        );
    }
}
