<?php

namespace Inside\CSV\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\File;
use Inside\CSV\Events\ImportFinishedEvent;
use Inside\CSV\Listeners\ImportFinishedListener;
use Inside\Providers\ServiceProvider;
use Maatwebsite\Excel\Imports\HeadingRowFormatter;

/**
 * Inside package user import service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserCSVServiceProvider extends ServiceProvider
{
    /** @var array<string, string[]>  */
    protected $listen = [
      ImportFinishedEvent::class => [
          ImportFinishedListener::class
      ]
    ];
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        HeadingRowFormatter::default(HeadingRowFormatter::FORMATTER_NONE);
        foreach ($this->listen as $event => $listeners) {
            foreach ($listeners as $listener) {
                Event::listen($event, $listener);
            }
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/import.php', 'import');
    }
}
