<?php

namespace Inside\CSV\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Inside\CSV\Services\UserImportService;
use Inside\Jobs\Bus\Dispatchable;
use Inside\Jobs\Job;

class UserImportJob extends Job implements ShouldQueue
{
    use Queueable;
    use InteractsWithQueue;
    use Dispatchable;

    public int $timeout = 3600;
    public int $tries = 1;

    public function __construct(
        private string $file,
        private bool $disableUsers,
        private string $processTracker
    ) {
    }

    public function handle(UserImportService $userImportService): void
    {
        $userImportService->import(
            $this->file,
            $this->disableUsers,
            $this->processTracker
        );
    }

    public function failed(\Throwable $exception): void
    {
        Log::error('UserImportJob failed: ' . $exception->getMessage());
    }
}
