<?php

namespace Inside\CSV\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Inside\CSV\Services\FeedValidationService;
use Inside\Jobs\Bus\Dispatchable;

class FeedValidationJob implements ShouldQueue
{
    use Queueable;
    use InteractsWithQueue;
    use Dispatchable;

    public function __construct(private string $file, private string $validationToken)
    {
    }

    public function handle(FeedValidationService $feedValidationService): void
    {
        $feedValidationService->execute($this->file, $this->validationToken);
    }
}
