<?php

namespace Inside\CSV\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Inside\CSV\Http\Requests\FeedImportRequest;
use Inside\CSV\Http\Requests\TokenRequest;
use Inside\CSV\Http\Requests\UserImportRequest;
use Inside\CSV\Jobs\UserImportJob;
use Inside\Support\Str;
use Laravel\Lumen\Routing\Controller;

/**
 * Import users from file
 *
 * Class CsvController
 * @package Inside\Csv\Http\Controllers
 */
class UserImportController extends Controller
{
    public function __construct()
    {
    }

    public function import(UserImportRequest $request): JsonResponse
    {
        $processTracker = Str::uuid();

        try {
            Cache::tags([$processTracker])->put('state', 0);
            Cache::tags([$processTracker])->put('errors', []);
            Cache::tags([$processTracker])->put('statistics', [
                'total' => 0,
                'imported' => 0,
                'disabled' => 0
            ]);
            $file = $request->get('file');
            $disableUsers = $request->get('disable_missing_users') !== false;
            Log::warning(" [UserImportController::import] : Importing users on tracke: {$processTracker}");
            UserImportJob::dispatch($file, $disableUsers, $processTracker);

            \Illuminate\Support\Facades\Log::warning("Debug User Controller", [
                "user" => \Illuminate\Support\Facades\Auth::user()
            ]);
        } catch (\Exception $exception) {
            Cache::tags([$processTracker])->put('state', 100);
            Cache::tags([$processTracker])->put('errors', [$exception->getMessage()]);
        }

        return response()->json([
            'tracker' => $processTracker
        ]);
    }

    public function stats(TokenRequest $request): JsonResponse
    {
        $processTracker = $request->input('token');

        return response()->json([
            'state' => Cache::tags([$processTracker])->get('state', 0),
            'errors' => array_unique(Cache::tags([$processTracker])->get('errors', [])),
            'statistics' => Cache::tags([$processTracker])->get('statistics', [
                'total' => 0,
                'imported' => 0,
                'disabled' => 0,
                'ignored' => 0
            ])
        ]);
    }
}
