<?php

namespace Inside\CSV\Http\Controllers;

use Inside\Validation\ValidateRequests;
use Laravel\Lumen\Routing\Controller;

/**
 * Import users from file
 *
 * Class CsvController
 * @package Inside\Csv\Http\Controllers
 */
class CsvController extends Controller
{
    use ValidateRequests;


    public function __construct()
    {
    }

    public function getSeparator(): array
    {
        $code = config('app.code');
        return [
            "separator" => config('csv.files.' . $code . '.separator')
        ];
    }

    public function getFields(): array
    {
        $code = config('app.code');
        return [
            "csv" => array_keys(config('csv.files.' . $code.'.original_fields') ?? []),
            "excel" => array_keys(config('xlsx.files.' . $code.'.original_fields') ?? [])
        ];
    }
}
