<?php

namespace Inside\CSV\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class ImportFinishedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    /** @var int */
    public $usersFound;

    /** @var int */
    public $importedUsers;

    /** @var int */
    public $disabledUsers;

    /** @var mixed */
    public $uploader;

    /**
     * @param int $usersFound
     * @param int $importedUsers
     * @param int $disabledUsers
     * @param mixed $uploader
     */
    public function __construct(int $usersFound, int $importedUsers, int $disabledUsers, $uploader)
    {
        $this->usersFound = $usersFound;
        $this->importedUsers = $importedUsers;
        $this->disabledUsers = $disabledUsers;
        $this->uploader = $uploader;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_csv_import_finished');
    }
}
