<?php

namespace Inside\CSV\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\CSV\Events\ImportFinishedEvent;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Listeners\BaseNotificationListener;

class ImportFinishedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ImportFinishedEvent $event): void
    {
        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::where([
            'event' => 'Inside\CSV\Events\ImportFinishedEvent',
            'action' => 'import'
        ])->first();

        $user = $event->uploader;

        $this->route = $user;
        $this->notify($notificationType, $user, null, [
            'total' => $event->usersFound,
            'imported' => $event->importedUsers,
            'disabled' => $event->disabledUsers
        ]);
    }
}
