<?php

namespace Inside\CSV\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Inside\CSV\Services\FeedValidationService;
use Inside\Jobs\Bus\Dispatchable;
use Inside\Jobs\Job;

class FeedValidationJob extends Job implements ShouldQueue
{
    use Queueable;
    use InteractsWithQueue;
    use Dispatchable;

    public function __construct(private string $file, private string $validationToken)
    {
    }

    public function handle(FeedValidationService $feedValidationService): void
    {
        $feedValidationService->execute($this->file, $this->validationToken);
    }

    public function failed(\Throwable $exception): void
    {
        Log::error('FeedValidationJob failed: ' . $exception->getMessage());
    }
}
