<?php

namespace Inside\CSV\Http\Controllers;

use Inside\CSV\Http\Requests\TemplateRequest;
use Inside\CSV\Services\TemplateDownloadService;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

/**
 * Export template file
 *
 * Class TemplateController
 * @package Inside\Csv\Http\Controllers
 */
class TemplateController extends Controller
{
    public function __construct(private TemplateDownloadService $templateDownloadService)
    {
    }

    /**
     * @param TemplateRequest $request
     * @return BinaryFileResponse
     */
    public function download(TemplateRequest $request): BinaryFileResponse
    {
        $format = $request->get('format');

        return $this->templateDownloadService->downloadTemplate($format);
    }
}
