<?php

namespace Inside\CSV\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Inside\CSV\Http\Requests\FeedValidationRequest;
use Inside\CSV\Http\Requests\TokenRequest;
use Inside\CSV\Jobs\FeedValidationJob;
use Inside\CSV\Services\FeedValidationService;
use Inside\Support\Str;
use Laravel\Lumen\Routing\Controller;

/**
 * Import users from file
 *
 * Class FeeValidationController
 * @package Inside\Csv\Http\Controllers
 */
class FeedValidationController extends Controller
{
    public function __construct()
    {
    }

    public function send(FeedValidationRequest $request): JsonResponse
    {
        $validationToken = Str::uuid();

        try {
            Cache::tags([$validationToken])->put('state', 0);
            Cache::tags([$validationToken])->put('errors', []);
            $file = $request->get('file');
            FeedValidationJob::dispatch($file, $validationToken);
        } catch (\Exception $exception) {
            Cache::tags([$validationToken])->put('state', 100);
            Cache::tags([$validationToken])->put('errors', [$exception->getMessage()]);
        }

        return response()->json([
            'token' => $validationToken
        ]);
    }

    public function check(TokenRequest $request): JsonResponse
    {
        $validationToken = $request->input('token');

        return response()->json([
            'state' => Cache::tags([$validationToken])->get('state', 0),
            'errors' => Cache::tags([$validationToken])->get('errors', [])
        ]);
    }
}
