<?php

namespace Inside\CSV\Actions\TemplateExport;

use Illuminate\Support\Facades\Lang;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Inside\CSV\Exceptions\FileNotFoundException;

class CsvExportStrategy implements ExportStrategy
{
    public function export(array $headers, array $exampleRow): BinaryFileResponse
    {
        $response = response();
        $code = config('app.code');
        $separator = config('csv.files.' . $code.'.separator');

        $filePath = storage_path('app/user-template.csv');
        $handle = fopen($filePath, 'w');

        if (!$handle) {
            throw new FileNotFoundException(
                Lang::get('validation.fail_open_file', [
                    'file' => basename($filePath)
                ]),
            );
        }
        fputcsv($handle, $headers, $separator);
        fputcsv($handle, $exampleRow, $separator);
        fclose($handle);

        return $response->download($filePath, 'user-template.csv')->deleteFileAfterSend(true);
    }
}
