
# Inside User AzureAD

# Requirements

| Requirement| Description |
|------------|---------|
| AZUREAD_APP_ID     | Unique ID of the application    |
| AZUREAD_TENANT     | Organization ID   |
| AZUREAD_SECRET_KEY | Secret key of the application    |

**APP_ID** and **SECRET_KEY** are available when you create an application.

To find the tenant : 

1. [https://portal.azure.com/#blade/Microsoft_AAD_IAM/ActiveDirectoryMenuBlade/RegisteredApps](https://portal.azure.com/#blade/Microsoft_AAD_IAM/ActiveDirectoryMenuBlade/RegisteredApps)
2. Click on "Endpoints" to retrieve any url, the tenant ID is inside.

Example : https://graph.windows.net/c954b16e-c461-4800-a008-0162eaee141d

# Installation

 1. Edit your .env file to put the following lines :
 
```
    AZUREAD_APP_ID={YOUR_APP_ID}
    AZUREAD_TENANT={YOUR_TENANT_ID}
    AZUREAD_SECRET_KEY={YOUR_SECRET_KEY}
```
    
# Microsoft Documentation
> [How to get an access token](https://docs.microsoft.com/fr-fr/azure/active-directory/develop/v1-oauth2-client-creds-grant-flow#request-an-access-token)

> [How to get resource data](https://docs.microsoft.com/fr-fr/azure/active-directory/develop/active-directory-graph-api-quickstart)

# Importation

```bash
 php artisan azuread:import --filter="accountEnabled eq true" 
 
 php artisan azuread:import --filter="accountEnabled eq true and mailNickname eq 'dd11a621-911d-40ad-92db-9958e4cf579d'"                
```
