<?php

return [
    'app_id'      => env('AZUREAD_APP_ID', false),
    'secret_key'  => env('AZUREAD_SECRET_KEY', false),
    'app_tenant'  => env('AZUREAD_TENANT', false),
    'api_version' => env('AZUREAD_GRAPH_API_VERSION', '1.6'),

    'graph_url' => env('AZUREAD_GRAPH_URL', env('MICROSOFT_GRAPH_URL', 'https://graph.windows.net')),
    'microsoft_api' => env('IS_MICROSOFT_API', false),

    'expand' => env('AZUREAD_EXPAND_FIELDS', null),

    'oauth2'          => [
        'url' => env('AZUREAD_OAUTH2_URL', 'https://login.microsoftonline.com'),
    ],

    // LaravelUserField => AzureUserField
    'sync_attributes' => [
        'name'  => 'displayName',
        'email' => 'mail',
    ],
    'custom_attributes' => [],
    'custom_security_attributes' => [],
    'discovering_attribute' => 'userPrincipalName',
    'group_id' => env('AZUREAD_GROUP_ID', null),
    'cert_thumbprint' => env('AZUREAD_CERT_THUMBPRINT', null),
    'cert_private_key_base64' => env('AZUREAD_SP_CERT_PRIVATE_KEY_BASE64', null),
];
