<?php

namespace Inside\AzureAD\Providers;

use Inside\AzureAD\Services\AzureADService;
use Inside\AzureAD\Services\AzureADAuth;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Inside package user via AzureAD service.
 *
 * @category Class
 * @package  Inside
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AzureADServiceProvider extends EventServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeConfigFrom(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/import.php', 'import');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
