# Inside Twitter

| Method | Endpoint | Parameters | Return |
|---|---|---|---|
| GET | /api/v1/twitter | search=USER_NAME &fields=FIELDS &count=NB_TWEET &endpoint=URL| [{item},{item}] |

**The `search` parameter is required**

Depending on the endpoint triggered it is either the twitter user_account or a filter to query tweets regardless the
user_account (filter meaning : keywork and / or hashtag => behave as twitter research)

**The `fields` parameter is optional**

By default `fields` parameter is :
```
$fields = [
    'created_at' => 0,
    'text' => 0,
    'user' => [
        'screen_name'
    ],
];
```

If the query parameter ```fields``` is provided, information about the related content and user can be fetched.

**The `endpoint` parameter is optional**

The `endpoint` parameter default value is : `https://api.twitter.com/1.1/statuses/user_timeline.json`

Two endpoints are allowed to query tweets :

-`https://api.twitter.com/1.1/statuses/user_timeline.json`
-`https://api.twitter.com/1.1/search/tweets.json`

**The `count` parameter is optional**

Define how many tweets the query should return (max) if not given, the default value set by the Twitter API is applied

**The parameters**

The `search` is a string and describe either the twitter account's name (@)
or the twitter account's "screen name" (alias). It also define the research parameter if the second endpoint is used.

The `fields` format is a JSON which describe the fields and subfield required, i.e. :

```json
{
  "created_at" : 0,
  "text" : 0,
  "user" : {
      "screen_name" : 0
   },
   "retweet_count" : 0,
   "favorite_count" : 0,
   "truncated" : 0,
   "entities" : {
      "urls" : {
          "url" : 0
      }
   }
}
```

The `key` is the field you want to query, if the value associated is `0` that mean you requested the value of field `key`.
If the value associated is an array, that mean you requested for the subfield value. (recursively)

THe `endpoint` parameter is a string and define the endpoint which need to be used for the request.

The `count` parameter is a number that define the number of tweets that should be returned (max)
