<?php

namespace Inside\TV\Services;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Inside\TV\Models\TvToken;

final class TvTokenService
{
    public const TV_TOKENS = 'tv_tokens';

    public function getAll(?string $tvScreenUuid): Collection
    {
        return $tvScreenUuid ? TvToken::whereHas(
            'tvScreen',
            fn ($query) => $query->where('uuid', $tvScreenUuid)
        )->get() :
            TvToken::all();
    }

    public function get(int $id): ?TvToken
    {
        return TvToken::where('id', $id)->first();
    }

    public function delete(int $id): bool
    {
        return TvToken::where('id', $id)->delete();
    }

    public function create(array $data): ?string
    {
        do {
            $token = Str::random(80);
            $hashedToken = Hash::make($token);
        } while (TvToken::where('token', $hashedToken)->exists());

        $data['token'] = $hashedToken;

        if (TvToken::where('title', $data['title'])->exists()) {
            return null;
        }

        TvToken::firstOrCreate(
            ['title' => $data['title']],
            $data
        );

        return $token;
    }

    public function exists(string $token): bool
    {
        return TvToken::withoutGlobalScopes()->pluck('token')->filter(
            fn (string $hash) => Hash::check($token, $hash)
        )->isNotEmpty();
    }
}
