<?php

namespace Inside\TV\Services;

use Illuminate\Database\Eloquent\Collection;
use Inside\TV\Models\TvIp;
use Symfony\Component\HttpFoundation\IpUtils;

final class TvIpService
{
    public function getAll(): Collection
    {
        return TvIp::all();
    }

    public function get(int $id): ?TvIp
    {
        return TvIp::where('id', $id)->first();
    }

    public function delete(int $id): bool
    {
        return TvIp::where('id', $id)->delete();
    }

    public function create(array $data): ?int
    {
        $tvIp = TvIp::firstOrCreate(
            ['ip' => $data['ip']],
            ['title' => $data['title']]
        );

        return $tvIp->id;
    }

    public function isWhitelisted(string $ip): bool
    {
        $ips = TvIp::withoutGlobalScopes()->pluck('ip')->toArray();
        return empty($ips) || IpUtils::checkIp($ip, $ips);
    }
}
