<?php

namespace Inside\TV\Services;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Redis;

class TVStatusService
{
    public const CACHE_KEY = 'tv:reload';
    public const CACHE_LIST = 'tv:list';

    public static function requestingRefresh(string $tvScreenId): void
    {
        $uuids = Redis::lrange(self::CACHE_LIST . $tvScreenId, 0, -1);
        foreach ($uuids as $uuid) {
            Cache::put(self::CACHE_KEY . '-' . $uuid, true, now()->addMinutes(15));
        }
    }

    public static function isRefreshNeeded(string $uuid): bool
    {
        return Cache::has(self::CACHE_KEY . '-' . $uuid);
    }

    public static function clearStatus(string $uuid, string $tvScreenId): void
    {
        Cache::forget(self::CACHE_KEY . '-' . $uuid);
        Redis::lrem(self::CACHE_LIST.$tvScreenId, 0, $uuid);
    }

    public static function registerUuid(string $uuid, string $tvScreenId): bool
    {
        return (bool) Redis::lpush(self::CACHE_LIST.$tvScreenId, $uuid);
    }
}
