<?php

namespace Inside\TV\Services;

use Illuminate\Support\Collection;
use Inside\Content\Facades\Schema;

class TVContentFilterService
{
    public function getValidContentTypes(): Collection
    {
        $prerequisites = collect(config('tv.modules', []));
        $dependencies = collect(config('tv.module_dependencies', []));

        return $prerequisites->reject(function ($module) use ($dependencies) {
            $moduleDependencies = collect($dependencies->get($module, []));
            return $moduleDependencies->contains(fn ($dependency) => !Schema::hasContentType($dependency));
        });
    }
}
