<?php

namespace Inside\TV\Services;

use Drupal\Core\Database\Log;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Content;
use Inside\Database\Eloquent\Builder;
use Inside\Host\Bridge\BridgeContent;

final class DeleteScreenTvSlidesService
{
    public function delete(string $tvScrennUuid): void
    {
        $modules = config('tv.modules');

        collect($modules)->each(fn (string $contentType) => $this->deleteContents(
            $contentType,
            $tvScrennUuid
        ));
    }

    private function deleteContents(
        string $contentType,
        string $tvScrennUuid
    ): void {
        $bridge = new BridgeContent();

        type_to_class($contentType)::query()
            ->whereHas('tvScreens', fn (Builder $query) => $query->where('uuid', $tvScrennUuid))
            ->get()
            ->each(fn (Content $content) => $bridge->contentDelete($contentType, (string) $content->uuid));

        // delete orphan contents
        type_to_class($contentType)::query()
            ->doesntHave('tvScreens')
            ->get()
            ->each(fn (Content $content) => $bridge->contentDelete($contentType, (string) $content->uuid));
    }
}
