<?php

namespace Inside\TV\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Contents\TvScreens;
use Inside\Content\Facades\Schema as InsideSchema;

/**
 * @method static Builder|static whereHas(string $relation, \Closure|null  $callback = null, string $operator = '>=', int $count = 1)
 * @method static Collection get(array $columns = ['*'])
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder withoutGlobalScopes()
 * @method static static firstOrCreate($data, $values)
 *
 * @property int $id
 * @property string $title
 * @property string $token
 */
class TvToken extends Model
{
    protected $table = 'inside_tv_tokens';

    protected $fillable = [
        'token',
        'title',
        'tv_screen_uuid'
    ];

    public function tvScreen(): ?BelongsTo
    {
        if (! InsideSchema::hasModel('tv_screens')) {
            return null;
        }
        return $this->belongsTo(TvScreens::class, 'tv_screen_uuid', 'uuid');
    }
}
