<?php

namespace Inside\TV\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * @method static Builder|static whereHas(string $relation, \Closure|null  $callback = null, string $operator = '>=', int $count = 1)
 * @method static Collection get(array $columns = ['*'])
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder withoutGlobalScopes()
 * @method static static firstOrCreate($data, $values)
 * @method Collection pluck($data)
 *
 * @property int $id
 * @property string $title
 * @property string $ip
 */
class TvIp extends Model
{
    protected $table = 'inside_tv_ips';

    protected $fillable = [
        'ip',
        'title'
    ];
}
