<?php

namespace Inside\TV\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentSavedEvent;
use Inside\TV\Services\TVStatusService;

class TVScreenAlteredListener implements ShouldQueue
{
    public function handle(ContentSavedEvent $event): void
    {
        $model = $event->model;

        TVStatusService::requestingRefresh((string)$model->screen_id);
    }
}
